package thirdPartyToolFramework;

import userFramework.UserState;

public class AbstractStateListener implements StateListener{
	
	private UserState userState;
	private UserView userView;
	private UI ui;
	
	public AbstractStateListener(UserState state, UI userInterface, UserView view){
		userState = state;
		ui = userInterface;
		userView = view;
	}
	public void update(){
		String state = userState.poll(this);
		userView.update(state);
		ui.setState(state);
	}
}
